<?php

class Vendedor {
    private $db;
    public function __construct()
    {
        $this->db = new Database;
    }

    public function User_Gral(){
    $this->db->query('SELECT vta_vendedores.id, vta_vendedores.rif, vta_vendedores.nombre, vta_vendedores.apellido, vta_vendedores.email, vta_vendedores.estatus, roles.roles
    FROM vta_vendedores INNER JOIN roles ON vta_vendedores.tipo = roles.id WHERE (((vta_vendedores.estatus)="Activo"))
    ORDER BY vta_vendedores.apellido');
    $result = $this->db->resultSet();
    return $result;
    }

    public function User_Roles(){
    $this->db->query('SELECT * from roles order by roles');
    $result = $this->db->resultSet();
    return $result;
    }

    public function User_Buscar($ced){
    $this->db->query('SELECT * from vta_vendedores where rif= :ced');
    $this->db->bind(':ced', $ced);
    $row = $this->db->single();

        //check the row
        if($this->db->rowCount() > 0){
            return true;
        }else{
            return false;
        }
    }

    public function User_Mail($ced){
    $this->db->query('SELECT * from vta_vendedores where email= :ced');
    $this->db->bind(':ced', $ced);
    $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
            return true;
        }else{
            return false;
        }
    }

    public function User_Guardar($data){
        $this->db->query('INSERT INTO vta_vendedores (rif, nombre,apellido,telefono1,telefono2,email,direccion,id_estado,tipo,adicional,password)
        VALUES (:rif, :nombre, :apellido, :telefono1, :telefono2, :correo, :direccion, :estado, :tipo, :adicional, :password)');
        $this->db->bind(':rif', $data['cedula']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':apellido', $data['apellido']);
        $this->db->bind(':telefono1', $data['telefono1']);
        $this->db->bind(':telefono2', $data['telefono2']);
        $this->db->bind(':correo', $data['correo']);
        $this->db->bind(':direccion', $data['direccion']);
        $this->db->bind(':estado', $data['estado']);
        $this->db->bind(':adicional', $data['adicional']);
        $this->db->bind(':tipo', $data['roles']);
        $this->db->bind(':password', $data['password']);
       //execute
        if($this->db->execute()){
        //        var_dump($this->db->execute());
        //echo "vfin";
      //  exit;
        return true;
        }else{
        //        var_dump($this->db->execute());
        //echo "ffin";
       // exit;
        return false;
        }
    }

    public function User_Actualizar($data){
        $this->db->query('UPDATE vta_vendedores SET nombre=:nombre,apellido=:apellido,telefono1=:telefono1,telefono2=:telefono2,email=:correo,direccion=:direccion,id_estado=:estado,tipo=:tipo,adicional=:adicional where id= :id');
        $this->db->bind(':id', $data['cedula']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':apellido', $data['apellido']);
        $this->db->bind(':telefono1', $data['telefono1']);
        $this->db->bind(':telefono2', $data['telefono2']);
        $this->db->bind(':correo', $data['correo']);
        $this->db->bind(':direccion', $data['direccion']);
        $this->db->bind(':estado', $data['estado']);
        $this->db->bind(':adicional', $data['adicional']);
        $this->db->bind(':tipo', $data['roles']);


      //execute
        if($this->db->execute()){
        //        var_dump($this->db->execute());
        //echo "vfin";
      //  exit;
        return true;
        }else{
        //        var_dump($this->db->execute());
        //echo "ffin";
       // exit;
        return false;
        }
    }


    public function User_Editar($ced){
    $this->db->query('SELECT * from vta_vendedores where id= :ced');
    $this->db->bind(':ced', $ced);
    $row = $this->db->single();
    return $row;
    }

    public function Inst_Buscar($id){
        $this->db->query('SELECT * FROM empresas WHERE rif= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();

        //check the row
        if($this->db->rowCount() > 0){
            return 'NOPUEDEBORRAR';
        }else{
            return true;
        }
    }


    public function EmpPlan($data){
        //var_dump($data);
        //exit;
        $this->db->query('SELECT plantillas.id_empresa, documentos.id_entidad, instituciones.siglas, tramites.nombre AS tra, subtramites.nombre AS sub, documentos.id
        FROM ((((plantillas INNER JOIN documentos ON plantillas.id_documento = documentos.id) INNER JOIN entidades ON documentos.id_entidad = entidades.id) INNER JOIN instituciones ON documentos.id_institucion = instituciones.id) INNER JOIN tramites ON documentos.id_tramite = tramites.id) INNER JOIN subtramites ON documentos.id_subtramite = subtramites.id
        WHERE (((plantillas.id_empresa)= :emp) AND ((documentos.id_entidad)= :doc))
        ORDER BY documentos.id_entidad, instituciones.siglas, tramites.nombre');
        $this->db->bind(':doc', $data['doc']);
        $this->db->bind(':emp', $data['emp']);
        $qry=$this->db->resultSet();
        return $qry;
    }

    public function EmpEnt($data){
        $this->db->query('SELECT instituciones.nombre, documentos.id_entidad, documentos.id_institucion
FROM documentos INNER JOIN instituciones ON documentos.id_institucion = instituciones.id
GROUP BY instituciones.nombre, documentos.id_entidad, documentos.id_institucion
HAVING (((documentos.id_entidad)= :doc)) ORDER BY instituciones.nombre');
        $this->db->bind(':doc', $data['idc']);
        $qry=$this->db->resultSet();
        return $qry;
    }

    public function EmpInst($data){
        $this->db->query('SELECT documentos.id, documentos.id_entidad, documentos.id_institucion, tramites.nombre as tra, subtramites.nombre as sub
FROM (documentos INNER JOIN subtramites ON documentos.id_subtramite = subtramites.id) INNER JOIN tramites ON documentos.id_tramite = tramites.id
WHERE (((documentos.id_entidad)= :ent) AND ((documentos.id_institucion)= :doc)) ORDER BY tramites.nombre');
        $this->db->bind(':doc', $data['idc']);
        $this->db->bind(':ent', $data['ent']);
        $qry=$this->db->resultSet();
        return $qry;
    }

    public function EmpInst0($data){
        $this->db->query('SELECT plantillas.id_empresa, instituciones.nombre, documentos.id_institucion
FROM plantillas INNER JOIN (documentos INNER JOIN instituciones ON documentos.id_institucion = instituciones.id) ON plantillas.id_documento = documentos.id
GROUP BY plantillas.id_empresa, instituciones.nombre, documentos.id_institucion
HAVING (((plantillas.id_empresa)= :inst)) ORDER BY instituciones.nombre');
        $this->db->bind(':inst', $data);
        $qry=$this->db->resultSet();
        return $qry;
    }

    public function Emp_Qry($id){
        $this->db->query('SELECT * FROM empresas WHERE id= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();

        //check the row
        if($this->db->rowCount() > 0){
            return $row;
        }else{
            return false;
        }
    }

    public function Inst_Busqueda($id){
        $this->db->query('SELECT * FROM empresas WHERE rif= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();

        //check the row
        if($this->db->rowCount() > 0){
            return 'NOPUEDEBORRAR';
        }else{
            return true;
        }
    }

    public function Inst_Bus($id){
        $this->db->query('SELECT * FROM empresas WHERE id= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();

        //check the row
        if($this->db->rowCount() > 0){
            return $row;
        }else{
            return false;
        }
    }

    public function Emp_Doc($data){
        $this->db->query('SELECT * FROM plantillas WHERE id_empresa= :emp and id_documento= :doc');
        $this->db->bind(':emp', $data['emp']);
        $this->db->bind(':doc', $data['doc']);
        $row = $this->db->single();

        //check the row
        if($this->db->rowCount() > 0){
            return true;
        }else{
            return false;
        }
    }

    public function Emp_Doc_G($data){
        $this->db->query('INSERT INTO plantillas (id_empresa,id_documento) values ( :emp, :doc)');
        $this->db->bind(':emp', $data['emp']);
        $this->db->bind(':doc', $data['doc']);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }

    public function Inst_Guardar($data){
        $this->db->query('INSERT INTO empresas (rif,nombre,telefono1,telefono2,email,direccion,id_estado,adicional,sitio,contacto,cargo,telefono3,celular,correo2)
        VALUES (:rif, :nombre, :telefono1, :telefono2, :correo, :direccion, :estado, :adicional, :pagina, :contacto, :cargo, :telefono3, :celular, :correo2)');
        $this->db->bind(':rif', $data['rif']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':telefono1', $data['telefono1']);
        $this->db->bind(':telefono2', $data['telefono2']);
        $this->db->bind(':correo', $data['correo']);
        $this->db->bind(':direccion', $data['direccion']);
        $this->db->bind(':estado', $data['estado']);
        $this->db->bind(':adicional', $data['adicional']);
        $this->db->bind(':pagina', $data['pagina']);

        $this->db->bind(':contacto', $data['contacto']);
        $this->db->bind(':cargo', $data['cargo']);
        $this->db->bind(':telefono3', $data['telefono3']);
        $this->db->bind(':celular', $data['celular']);
        $this->db->bind(':correo2', $data['correo2']);
       //execute
        if($this->db->execute()){
        //        var_dump($this->db->execute());
        //echo "vfin";
      //  exit;
        return true;
        }else{
        //        var_dump($this->db->execute());
        //echo "ffin";
       // exit;
        return false;
        }
    }

    public function Inst_Actualiza($data){
        $this->db->query('UPDATE empresas SET
        nombre=:nombre,telefono1=:telefono1,telefono2=:telefono2,email=:correo,direccion=:direccion,id_estado=:estado,adicional=:adicional,sitio=:pagina,contacto=:contacto,cargo=:cargo,telefono3=:telefono3,celular=:celular,correo2=:correo2
        WHERE rif = :rif');

        $this->db->bind(':rif', $data['rif']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':telefono1', $data['telefono1']);
        $this->db->bind(':telefono2', $data['telefono2']);
        $this->db->bind(':correo', $data['correo']);
        $this->db->bind(':direccion', $data['direccion']);
        $this->db->bind(':estado', $data['estado']);
        $this->db->bind(':adicional', $data['adicional']);
        $this->db->bind(':pagina', $data['pagina']);

        $this->db->bind(':contacto', $data['contacto']);
        $this->db->bind(':cargo', $data['cargo']);
        $this->db->bind(':telefono3', $data['telefono3']);
        $this->db->bind(':celular', $data['celular']);
        $this->db->bind(':correo2', $data['correo2']);
       //execute
        if($this->db->execute()){
        //        var_dump($this->db->execute());
        //echo "vfin";
      //  exit;
        return true;
        }else{
        //        var_dump($this->db->execute());
        //echo "ffin";
       // exit;
        return false;
        }
    }

   //delete a post
    public function deletePro($id){
        $idCond=$_SESSION['id_edif'];
        $this->db->query('DELETE FROM propietarios WHERE id_edificio= :idCond and inmueble = :id');
        $this->db->bind(':id', $id);
        $this->db->bind(':idCond', $idCond);
        if($this->db->execute()){
            return true;
        }else{
            return false;
        }
    }

    public function delete($id){
        $this->db->query('DELETE FROM vta_vendedores WHERE id= :id');
        $this->db->bind(':id', $id);
        if($this->db->execute()){
            return true;
        }else{
            return false;
        }
    }

    public function countPro(){
//        $idCond=$_SESSION['id_edif'];
        $this->db->query('SELECT id FROM vta_vendedores');
//        $this->db->bind(':idCond', $idCond);
        $result = $this->db->resultSet();

        //check the row
        return $this->db->rowCount();
    }

    public function sumaPro(){
//        $idCond=$_SESSION['id_edif'];
        $this->db->query('SELECT SUM(nombre) as sumapro FROM vta_vendedores');
        return $this->db->rowSuma();
    }

    public function countEdif2x($data){
        //$this->db->query('SELECT codigo FROM edificiors');
        $v1=$data['v1'];
        $v2=$data['v2'];
        $qry= "SELECT * from propietarios where ".$v1." like '".$v2."%' order by inmueble";
        $this->db->query($qry);
        $result = $this->db->resultSet();
        //check the row
        return $this->db->rowCount();
    }

    public function pagoPro($data){
//var_dump($data);
        $this->db->query('INSERT INTO pagos(id_inmueble,fecha,forma,detalle,documento,banco,monto,nota_credito_n,nota_credito_p)
        VALUES (:id_inmueble, :fecha, :pago, :detalle, :documento, :banco, :monto, :nota_cr, :nota_cr0)');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':fecha', $data['fecha']);
        $this->db->bind(':pago', $data['pago']);
        $this->db->bind(':detalle', $data['detalle']);
        $this->db->bind(':documento', $data['documento']);
        $this->db->bind(':banco', $data['banco']);
        $this->db->bind(':monto', $data['monto']);
        $this->db->bind(':nota_cr', $data['nota_cr']);
        $this->db->bind(':nota_cr0', $data['nota_cr0']);
        //execute
        $id_rec = $this->db->executelast();

        if($data['nota_cr']>0){
        $this->db->query('INSERT INTO pagos_nc(id_pago,id_inmueble,fecha,monto)
        VALUES (:id_pago, :id_inmueble, :fecha, :monto)');
        $this->db->bind(':id_pago', $id_rec);
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':fecha', $data['fecha']);
        $this->db->bind(':monto', $data['nota_cr']);
        //execute
        $this->db->execute();

        $this->db->query('UPDATE propietarios SET saldo=saldo- :saldo, nota_credito= :monto WHERE id = :id_inmueble');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':monto', $data['nota_cr']);
        $this->db->bind(':saldo', $data['monto']);
        //execute
        $this->db->execute();
        }else{
        $this->db->query('UPDATE propietarios SET recibos=recibos-1,saldo=saldo- :saldo, nota_credito=0 WHERE id = :id_inmueble');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':saldo', $data['monto']); 
        //execute
        $this->db->execute();
        }
        return $id_rec;
    }

}