<?php

class Inventario {
    private $db;
    public function __construct()
    {
        $this->db = new Database;
    }

    public function Inv_Cli_Gral(){
    $this->db->query('SELECT * FROM vta_clientes order by nombre');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Inv_Ven_Gral(){
    $this->db->query('SELECT * FROM vta_vendedores order by nombre');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Inv_Gral_Alm(){
    $this->db->query('SELECT * FROM vta_almacenes order by id');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Inv_Gral_Mov(){
    $this->db->query('SELECT vta_productos_mov.*, vta_categorias.categoria
FROM (vta_productos_mov INNER JOIN vta_productos ON vta_productos_mov.codigo = vta_productos.codigo) INNER JOIN vta_categorias ON vta_productos.codigo_cat = vta_categorias.codigo
ORDER BY vta_productos_mov.codigo_alm, vta_categorias.categoria');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Inv_Prod_Gral(){
    $this->db->query('SELECT * FROM vta_productos order by codigo_cat');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Inv_Fact_Gral($desde,$resultados){
    //$this->db->query('SELECT * FROM vta_factura Where estado="Activo" order by id desc');

$this->db->query('SELECT vta_factura.*, vta_clientes.nombre as cli, vta_vendedores.nombre as vend
FROM (vta_factura INNER JOIN vta_clientes ON vta_factura.id_cliente = vta_clientes.id) INNER JOIN vta_vendedores ON vta_factura.id_vendedor = vta_vendedores.id
WHERE (((vta_factura.estado)="Activo")) ORDER BY vta_factura.id DESC limit :desde,:resultados' );
    $this->db->bind(':desde', $desde);
    $this->db->bind(':resultados', $resultados);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Prod_Gral($desde,$resultados){
    $this->db->query('SELECT * from vta_productos order by nombre limit :desde,:resultados');
    $this->db->bind(':desde', $desde);
    $this->db->bind(':resultados', $resultados);
    $result = $this->db->resultSet();
    return $result;
    }

   public function Prod_Gral_Ent(){
//    $this->db->query('SELECT * from vta_entrada order by fecha');
	
$this->db->query('SELECT vta_entrada.*, vta_almacenes.nombre as alm, usuarios.nombre as usu
FROM (vta_entrada INNER JOIN vta_almacenes ON vta_entrada.almacen = vta_almacenes.id) INNER JOIN usuarios ON vta_entrada.usuario = usuarios.id
ORDER BY vta_entrada.fecha DESC' );

    $result = $this->db->resultSet();
    return $result;
    }

    public function Inv_Fact_Gral_Busq($dataa){
        $v1=$dataa['busca'];
        $v2=$dataa['busqueda'];
    //    $qry= "SELECT * from vta_productos where ".$v1." like '%".$v2."%' order by nombre";

        $qry= "SELECT vta_factura.*, vta_clientes.nombre as cli, vta_vendedores.nombre as vend
FROM (vta_factura INNER JOIN vta_clientes ON vta_factura.id_cliente = vta_clientes.id) INNER JOIN vta_vendedores ON vta_factura.id_vendedor = vta_vendedores.id
WHERE vta_factura.estado='Activo' and ".$v1." like '%".$v2."%' ORDER BY vta_factura.id DESC";
    $this->db->query($qry);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Inv_Fact_Busq($id){
//    $this->db->query('SELECT vta_entrada.*, vta_clientes.nombre as cli,vta_clientes.telefono1,vta_clientes.direccion, vta_vendedores.nombre as vend
//FROM (vta_entrada INNER JOIN vta_clientes ON vta_entrada.id_cliente = vta_clientes.id) INNER JOIN vta_vendedores ON vta_factura.id_vendedor = vta_vendedores.id
//WHERE vta_entrada.id= :id');

$this->db->query('SELECT vta_entrada.*, vta_almacenes.nombre as alm, usuarios.nombre as usu
FROM (vta_entrada INNER JOIN vta_almacenes ON vta_entrada.almacen = vta_almacenes.id) INNER JOIN usuarios ON vta_entrada.usuario = usuarios.id
WHERE vta_entrada.id= :id' );

    $this->db->bind(':id', $id);
    $result = $this->db->single();
    return $result;
    }

    public function countPro_Busq($dataa){
        $v1=$dataa['busca'];
        $v2=$dataa['busqueda'];
        $qry= "SELECT vta_factura.*, vta_clientes.nombre as cli, vta_vendedores.nombre as vend
FROM (vta_factura INNER JOIN vta_clientes ON vta_factura.id_cliente = vta_clientes.id) INNER JOIN vta_vendedores ON vta_factura.id_vendedor = vta_vendedores.id
WHERE vta_factura.estado='Activo' and ".$v1." like '%".$v2."%' ORDER BY vta_factura.id DESC";
        $this->db->query($qry);
        $result = $this->db->resultSet();
        //check the row
        return $this->db->rowCount();
    }

    public function Prod_Actualiza($data){
        $this->db->query('UPDATE vta_productos SET nombre=:nombre,precio1=:precio1,precio2=:precio2,precio3=:precio3,costo=:costo,medida=:medida,minimo=:minimo,ubicacion=:ubicacion,exento=:exento WHERE id=:id');
        $this->db->bind(':id', $data['id']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':precio1', $data['precio1']);
        $this->db->bind(':precio2', $data['precio2']);
        $this->db->bind(':precio3', $data['precio3']);
        $this->db->bind(':costo', $data['costo']);
        $this->db->bind(':medida', $data['medida']);
        $this->db->bind(':minimo', $data['minimo']);
        $this->db->bind(':exento', $data['exento']);
        $this->db->bind(':ubicacion', $data['ubicacion']);
       //execute
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }

    public function Inv_GuardarItem($data){
//var_dump($data);
//exit;
        $this->db->query('INSERT INTO vta_entrada_det (codigo,precio_bs,cantidad,exento,medida,control)
        VALUES (:codigo22, :precio1,:cantidad,:exento, :medida, :token)');
        $this->db->bind(':codigo22', $data['codigo22']);
		$this->db->bind(':precio1', $data['precio1']);
		$this->db->bind(':medida', $data['medida']);
        $this->db->bind(':token', $data['token']);
        $this->db->bind(':cantidad', $data['cantidad']);
        $this->db->bind(':exento', $data['exento']);
       //execute
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }
	
    public function Inv_Fact_GuardatItem($data,$itemes){

		
	foreach ($itemes as $p){	
        $this->db->query('SELECT * FROM vta_productos_mov WHERE codigo= :cod_prod and codigo_alm=:cod_alm');
        $this->db->bind(':cod_prod', $p->codigo);
		$this->db->bind(':cod_alm', $data);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){

			$this->db->query('UPDATE vta_productos_mov SET existencia=existencia+:existenciaX WHERE codigo=:codigo AND codigo_alm=:codigo_alm');
			$this->db->bind(':codigo', $p->codigo);
			$this->db->bind(':codigo_alm', $data);
			$this->db->bind(':existenciaX', $p->cantidad);
			$this->db->execute();

			}else{
			
			$this->db->query('INSERT INTO vta_productos_mov (codigo,codigo_alm,existencia) VALUES (:codigo,:codigo_alm, :existencia)');
			$this->db->bind(':codigo', $p->codigo);
			$this->db->bind(':codigo_alm', $data);
			$this->db->bind(':existencia', $p->cantidad);
			$this->db->execute();
			//return false;
        }	
	}
//echo $dataEnt->alm;
//var_dump($itemes);
//exit;		
return true;
	}

    public function Inv_GuardarFact($data,$itemes){

    $this->db->startTransaction();
        $this->db->query('INSERT INTO vta_entrada (usuario,almacen,fecha)
        VALUES (:usuario, :almacen, :fecha)');
        $this->db->bind(':usuario', $data['usuario']);
        $this->db->bind(':almacen', $data['almacen']);
        $this->db->bind(':fecha', $data['fecha']);
        $last=$this->db->executelast();

		$this->db->query('UPDATE vta_entrada_det SET id_entrada=:id_nro,control=0 WHERE control = :idran');
        $this->db->bind(':idran', $data['token']);
        $this->db->bind(':id_nro', $last);
        $this->db->execute();
        //return $last;

    $this->db->query('UPDATE vta_productos SET existencia=existencia+:cant WHERE codigo = :codigo');
    foreach ($itemes as $p){
        $this->db->bind(':cant', $p->cantidad);
        $this->db->bind(':codigo', $p->codigo);
        $this->db->execute();
    }
	
//return true;
    if($this->db->submitTransaction()){
	return $last;
    }else{
    return false;
    }
    }
	
	public function Inv_MovFact($data){

	}

    public function Inv_BuscarCliente($id){
        $this->db->query('SELECT * FROM vta_clientes WHERE id= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return $row;
        }else{
        return false;
        }
    }

    public function Inv_BuscarItem($id){
//        $this->db->query('SELECT vta_entrada_det.*, vta_productos.categoria
//FROM vta_entrada_det INNER JOIN vta_productos ON vta_entrada_det.codigo = vta_productos.codigo
//WHERE vta_entrada_det.control= :id ORDER BY vta_productos.codigo_cat');


$this->db->query('SELECT vta_entrada_det.*, vta_categorias.categoria
FROM (vta_entrada_det INNER JOIN vta_productos ON vta_entrada_det.codigo = vta_productos.codigo) INNER JOIN vta_categorias ON vta_productos.codigo_cat = vta_categorias.codigo
WHERE vta_entrada_det.control=:id ORDER BY vta_categorias.categoria');


        $this->db->bind(':id', $id);
        $result = $this->db->resultSet();
        if($this->db->rowCount() > 0){
        return $result;
        }else{
        return false;
        }
    }

    public function Inv_Fact_BuscarItem($id){
$this->db->query('SELECT vta_entrada_det.*, vta_categorias.categoria
FROM (vta_entrada_det INNER JOIN vta_productos ON vta_entrada_det.codigo = vta_productos.codigo) INNER JOIN vta_categorias ON vta_productos.codigo_cat = vta_categorias.codigo
WHERE vta_entrada_det.id_entrada=:id ORDER BY vta_categorias.categoria');

        $this->db->bind(':id', $id);
        $result = $this->db->resultSet();
        if($this->db->rowCount() > 0){
        return $result;
        }else{
        return false;
        }
    }

    public function Prod_BuscarCod($id){
        $this->db->query('SELECT * FROM vta_productos WHERE codigo= :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
        return false;
        }else{
        return true;
        }
    }

   //delete a post
    public function Inv_deleteitem($id){
        $this->db->query('DELETE FROM vta_entrada_det WHERE id= :id');
        $this->db->bind(':id', $id);
        if($this->db->execute()){
            return true;
        }else{
            return false;
        }
    }

    public function aPag_countPro(){
        $this->db->query('SELECT id FROM vta_factura Where estado="Activo"');
        $result = $this->db->resultSet();
        //check the row
        return $this->db->rowCount();
    }

    public function getMEDIDA(){
        $this->db->query('SELECT * FROM vta_medidas order by medida');
        $result = $this->db->resultSet();
        //check the row
        return $result;
    }

    public function aPag_sumaPro(){
        $this->db->query('SELECT SUM(id) as sumapro FROM vta_factura Where estado="Activo"');
        return $this->db->rowSuma();
    }

    public function pagoPro($data){
        $this->db->query('INSERT INTO pagos(id_inmueble,fecha,forma,detalle,documento,banco,monto,nota_credito_n,nota_credito_p)
        VALUES (:id_inmueble, :fecha, :pago, :detalle, :documento, :banco, :monto, :nota_cr, :nota_cr0)');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':fecha', $data['fecha']);
        $this->db->bind(':pago', $data['pago']);
        $this->db->bind(':detalle', $data['detalle']);
        $this->db->bind(':documento', $data['documento']);
        $this->db->bind(':banco', $data['banco']);
        $this->db->bind(':monto', $data['monto']);
        $this->db->bind(':nota_cr', $data['nota_cr']);
        $this->db->bind(':nota_cr0', $data['nota_cr0']);
        //execute
        $id_rec = $this->db->executelast();

        if($data['nota_cr']>0){
        $this->db->query('INSERT INTO pagos_nc(id_pago,id_inmueble,fecha,monto)
        VALUES (:id_pago, :id_inmueble, :fecha, :monto)');
        $this->db->bind(':id_pago', $id_rec);
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':fecha', $data['fecha']);
        $this->db->bind(':monto', $data['nota_cr']);
        //execute
        $this->db->execute();

        $this->db->query('UPDATE propietarios SET saldo=saldo- :saldo, nota_credito= :monto WHERE id = :id_inmueble');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':monto', $data['nota_cr']);
        $this->db->bind(':saldo', $data['monto']);
        //execute
        $this->db->execute();
        }else{
        $this->db->query('UPDATE propietarios SET recibos=recibos-1,saldo=saldo- :saldo, nota_credito=0 WHERE id = :id_inmueble');
        $this->db->bind(':id_inmueble', $data['inmueble']);
        $this->db->bind(':saldo', $data['monto']); 
        //execute
        $this->db->execute();
        }
        return $id_rec;
    }

}