<?php
use csrfhandler\csrf as csrf;
class Inventarios extends Controller{

    public function __construct()
    {
        if(!isLoggedIn()){
            redirect('users/login');
        }
        //new model instance
        $this->Model_Alm = $this->model('Almacen');
        $this->Model_Pro = $this->model('Producto');
        $this->Model_Usu = $this->model('Usuario');
        $this->Model_Inv = $this->model('Inventario');
    }

    public function inicio(){
    $this->index(1);
    }

    public function index($n){
    $clientes       = $this->Model_Inv->Inv_Cli_Gral();
    $vendedores    = $this->Model_Inv->Inv_Ven_Gral();
    $productos      = $this->Model_Inv->Inv_Prod_Gral();
    $tokken = [
    'token' => csrf::token(),
    'paridad' => $_SESSION['id_par'],
    ];

    $msj_err=isErrorIn();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $twig->addGlobal('msj_err',$msj_err);
//    $layout = $twig->load('inc/base.html.twig');
    echo $twig->render('inventario/factura.html.twig', ['tokken'=>$tokken,'clientes' => $clientes,'vendedores' => $vendedores,'productos'=>$productos]);
    }

   public function entrada(){
    $almacen     = $this->Model_Alm->Alm_Gral();
    $usuarios    = $this->Model_Usu->User_Gral();
    $productos   = $this->Model_Pro->Prod_Gral();

//var_dump($productos);
//exit;

    $tokken = [
    'token' => csrf::token(),
    'paridad' => $_SESSION['id_par'],
    ];

    $msj_err=isErrorIn();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $twig->addGlobal('msj_err',$msj_err);
//    $layout = $twig->load('inc/base.html.twig');
    echo $twig->render('inventario/entrada.html.twig', ['tokken'=>$tokken,'usuarios' => $usuarios,'almacen' => $almacen,'productos'=>$productos]);
    }

    public function nuevo(){
    $tokken = [
    'token' => csrf::token(),
    ];

    $estatal = $this->Model_Est->getEstado();
    foreach ($estatal as $p){
    $estados[] = [
    'id' => $p->id,
    'estado' => utf8_encode($p->estado),
    ];
    }

    $msj_err=isErrorIn();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $twig->addGlobal('msj_err',$msj_err);
    $layout = $twig->load('inc/base.html.twig');
    echo $twig->render('proveedores/nuevo.html.twig', ['estados' => $estados,'tokken'=>$tokken]);
    }

    //show single post
    public function editar($id){
    $tokken = [
    'token' => csrf::token(),
    ];
    $estatal = $this->Model_Est->getEstado();

    foreach ($estatal as $p){
    $estados[] = [
    'id' => $p->id,
    'estado' => utf8_encode($p->estado),
    ];
    }
//var_dump($estados);
    $data=$this->Model_Pro->Prov_BuscarId($id);
    if($data){
    }else{
    redirect('proveedores');
    exit;
    }

    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
//    $layout = $twig->load('inc/base.html.twig');
    echo $twig->render('proveedores/editar.html.twig', ['estados' => $estados,'datos' => $data,'tokken'=>$tokken]);
    }

     //edit post
    public function actualizar(){
    $estados = $this->Model_Est->getEstado();
    $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
    if($_SERVER['REQUEST_METHOD'] == 'POST'){

    $data = [
    'id' =>strtoupper(trim($_POST['id'])),
    'nombre' =>strtoupper(trim($_POST['nombre'])),
    'telefono1' =>strtoupper($_POST['telefono1']),
    'telefono2' =>strtoupper($_POST['telefono2']),
    'correo' =>strtolower($_POST['correo']),
    'sitio' =>strtolower($_POST['sitio']),
    'direccion' =>strtoupper($_POST['direccion']),
    'id_estado' =>$_POST['id_estado'],
    'adicional' =>$_POST['adicional'],

    'contacto' =>strtoupper($_POST['contacto']),
    'cargo' =>strtolower($_POST['cargo']),
    'telefono3' =>$_POST['telefono3'],
    'celular' =>$_POST['celular'],
    'correo2' =>strtolower($_POST['correo2']),
    ];

            if(strlen(trim($data['nombre']))<=0){
            $_SESSION['error_msg'] = 'Escriba un Nombre...';
            }

            if(strlen(trim($data['nombre']))>0){
                if($this->Model_Pro->Prov_BuscarId($data['id'])){
                        if($this->Model_Pro->Prov_Actualiza($data)){
                        redirect('proveedores');
                        exit;
                        }else{
                        $_SESSION['error_msg'] = 'No se guardaron los datos...';
                        }
                }else{
                $_SESSION['error_msg'] = 'Proveedor NO registrado...';
                }
            }
                $msj_err=isErrorIn();
                $loader = new \Twig\Loader\FilesystemLoader('../app/views');
                $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
//                $layout = $twig->load('inc/base.html.twig');
                $twig->addGlobal('names',$_SESSION['user_id']);
                $twig->addGlobal('msj_err',$msj_err);
                echo $twig->render('proveedores/editar.html.twig', ['estados' => $estados,'datos' => $data]);
    }else{
    redirect('proveedores');
    }
    }

    public function guardar(){
    $estados = $this->Model_Est->getEstado();
    $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
    if($_SERVER['REQUEST_METHOD'] == 'POST'){

    $isValid = csrf::post();
    if($isValid) {
    //echo "Valid Token"; //show text when valid
    } else {
    //echo "Invalid Token"; //show text when invalid
    $_SESSION['error_msg'] = "Error Mensaje";
    redirect('proveedores');
    exit;
    }

    $data = [
    'rif' =>strtoupper(trim($_POST['rif'])),
    'nombre' =>strtoupper(trim($_POST['nombre'])),
    'telefono1' =>strtoupper($_POST['telefono1']),
    'telefono2' =>strtoupper($_POST['telefono2']),
    'correo' =>strtolower($_POST['correo']),
    'sitio' =>strtolower($_POST['sitio']),
    'direccion' =>strtoupper($_POST['direccion']),
    'id_estado' =>$_POST['id_estado'],
    'adicional' =>$_POST['adicional'],

    'contacto' =>strtoupper($_POST['contacto']),
    'cargo' =>strtolower($_POST['cargo']),
    'telefono3' =>$_POST['telefono3'],
    'celular' =>$_POST['celular'],
    'correo2' =>strtolower($_POST['correo2']),
    ];

            if(strlen(trim($data['rif']))<=10){
            $_SESSION['error_msg'] = 'Escriba un RIF...';
            }

            if(strlen(trim($data['nombre']))<=0){
            $_SESSION['error_msg'] = 'Escriba un Empresa...';
            }

            if(strlen(trim($data['nombre']))>0){
                if($this->Model_Pro->Prov_BuscarRif($data['rif'])){
                        if($this->Model_Pro->Prov_Guardar($data)){
                        redirect('proveedores');
                        exit;
                        }else{
                        $_SESSION['error_msg'] = 'No se guardaron los datos...';
                        }
                }else{
                $_SESSION['error_msg'] = 'RIF ya registrado...';
                }
            }
    }else{
    redirect('proveedores/nuevo');
    }
    }

    public function guardaritem(){
//var_dump($_POST);
//return;
    $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
    if($_SERVER['REQUEST_METHOD'] == 'POST'){

/*    $isValid = csrf::post();
    if($isValid) {
    //echo "Valid Token"; //show text when valid
    } else {
    //echo "Invalid Token"; //show text when invalid
    $_SESSION['error_msg'] = "Error Mensaje";
    redirect('inventarios/factura');
    exit;
    }*/

$field08 = $_POST['precio1'];
    if(strstr($_POST['precio1'], ",")) {
        $field08 = str_replace(".", "", $_POST['precio1']); // replace dots (thousand seps) with blancs
        $field08 = str_replace(".", "", $field08); // replace ',' with '.'
        $field08 = str_replace(".", "", $field08); // replace ',' with '.'
        $field08 = str_replace(".", "", $field08); // replace ',' with '.'
        $field08 = str_replace(",", ".", $field08); // replace ',' with '.'
    }


    $data = [
    'codigo22' =>trim($_POST['codigo22']),
    'medida' =>$_POST['medida'],
    'exento' =>$_POST['exento'],
    'precio1' =>$field08,
    'cantidad' =>$_POST['cantidad'],
    'token' =>$_POST['_token'],
    ];
//var_dump($data);
//return;
/*
            if(strlen(trim($data['rif']))<=10){
            $_SESSION['error_msg'] = 'Escriba un RIF...';
            }

            if(strlen(trim($data['nombre']))<=0){
            $_SESSION['error_msg'] = 'Escriba un Empresa...';
            }*/

        //    if(strlen(trim($data['nombre']))>0){
                        if($this->Model_Inv->Inv_GuardarItem($data)){


                        $this->listaritem($data['token']);

                        exit;
                        }else{
                        $_SESSION['error_msg'] = 'No se guardaron los datos...';
                        }
        //    }
    }else{
    redirect('inventarios/factura');
    }
    }

    public function guardarfact(){
//var_dump($_POST);
//exit;
    $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
    if($_SERVER['REQUEST_METHOD'] == 'POST'){

/*    $isValid = csrf::post();
    if($isValid) {
    //echo "Valid Token"; //show text when valid
    } else {
    //echo "Invalid Token"; //show text when invalid
    $_SESSION['error_msg'] = "Error Mensaje";
    redirect('inventarios/factura');
    exit;
    }*/

    $data = [
    'almacen' =>trim($_POST['almacen']),
    'usuario' =>trim($_POST['usuario']),
    'fecha' =>$_POST['fecha'],
    'token' =>$_POST['_token'],
    ];


$itemes=$this->Model_Inv->Inv_BuscarItem($data['token']);

if($itemes){
}else{
$_SESSION['error_msg'] = 'No hay productos para PROCESAR...';
redirect('inventarios/entrada');
exit;
}
$dataa=$this->Model_Inv->Inv_GuardarFact($data,$itemes);

$dataEnt=$this->Model_Inv->Inv_Fact_Busq($dataa);

$dataItem=$this->Model_Inv->Inv_Fact_BuscarItem($dataa);
$datalm=$dataEnt->almacen;
$dataMov=$this->Model_Inv->Inv_Fact_GuardatItem($datalm,$dataItem);


//echo $dataEnt->alm;
//var_dump($dataItem);
//exit;
						if($dataMov){
                        redirect('inventarios/procesadas');
                        exit;
                        }else{
                        $_SESSION['error_msg'] = 'No se guardaron los datos...';
						redirect('inventarios/entrada');
						exit;
                        }
    }else{
    redirect('inventarios/entrada');
    }
    }

public function listaritem($id){
$items=$this->Model_Inv->Inv_BuscarItem($id);
if($items==false){
echo '<b>NO HAY REGISTROS PARA MOSTRAR</b>';
return;
}
$total=0;$total2=0;$totaliva=0;
$html ='<table class="table table-striped table-hover table-sm">
    <thead style=" background-color: #003366; color:#FFFFFF;">
        <tr>
            <th class="text-center">Codigo</th>
            <th class="text-center">Producto</th>
            <th class="text-center">Medida</th>
            <th class="text-center">Cant.</th>
            <th class="text-center">&nbsp;</th>
        </tr>
    </thead>';
    //$id_iva=$_SESSION['id_iva'];
    foreach ($items as $p){
    //$tprecio_bs=round($p->precio_bs*$p->cantidad, 2);
    //$tprecio_paridad=round($p->precio_paridad*$p->cantidad, 2);
    //if(strtoupper($p->exento)=='SI'){
    //$tiva=0;
    //}else{
    //$tiva=round(($tprecio_bs*$id_iva)/100, 2);
    //}
    $html .='
    <tr>
    <td class="text-center">'.$p->codigo.'</td>
    <td>'.$p->categoria.'</td>
    <td class="text-center">'.$p->medida.'</td>
    <th class="text-center">'.number_format($p->cantidad, 2, ',', '.').'</th>
    <td class="text-center"><a href="" class="button2 btn btn-danger btn-sm" data-id="'.$p->id.'" data-token="'.$id.'" data-ruta="{{ constant("URLROOT2") }}/inventarios/borraritem"  data-toggle="tooltip" data-placement="top" title="Eliminar Registro"><i class="fa fa-trash"></i></a></td>
    </tr>
    ';
    }
$html .='</table>';
                       // var_dump($items);
                       echo $html;

}
    public function borraritem(){
    $data = [
    'id' =>$_POST['id'],
    'token' =>$_POST['token'],
    ];
  //      var_dump($data);
 //      return;
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            //check for owner
          //  $post = $this->ProModel->getPostById($id);
         //   if($post->user_id != $_SESSION['user_id']){
         //       redirect('propietarios');
         //   }

            //call delete method from post model
            if($this->Model_Inv->Inv_deleteitem($data['id'])){
                $this->listaritem($data['token']);
                return;
                //redirect('propietarios');
            }else{
                die('something went wrong');
            }
        }else{
            return;
            //redirect('propietarios');
        }
    }

    public function buscar(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        $idCond=$_SESSION['id_edif'];
        $dataa = [
        'v1' => trim($_POST['busca']),
        'v2' => trim($_POST['busqueda']),
        'idCond' => trim($idCond),
         ];

    $total_reg=$this->ProModel->countPro();
    $propietarios = $this->ProModel->busPro($dataa);

    $paginacion = [
    'total_paginas' => 1,
    'pagina_actual' => 1,
    'total_reg' => $total_reg,
    ];
  //  $estados = $this->estModel->getEstado();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $layout = $twig->load('inc/base.html.twig');
    echo $twig->render('propietarios/index.html.twig', ['propietarios' => $propietarios,'paginacion' => $paginacion]);
    }
    }

    public function buscar_ajax() {
    if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
    //var_dump($_POST);
    $id_cta=$_POST['id'];
    //var_dump($id_cta);
    $pos = strlen(trim($id_cta));
            if ($pos < 12) { // nota: tres signos de igual
            //    $pos='no encontrado...';
            echo 'NOPUEDEBORRAR';
            exit;
            }
   $nro_pago=$this->Model_Pro->Prov_Buscar($id_cta);
   echo $nro_pago;
   }
   }

    public function buscar_cliente(){
    if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
    //var_dump($_POST);
    $id_cli=$_POST['id'];

    $nro_cli=$this->Model_Inv->Inv_BuscarCliente($id_cli);
    echo json_encode($nro_cli);
    }
    }


    public function procesadas(){
    $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
    $entradas = $this->Model_Inv->Prod_Gral_Ent();
   
    $msj_err=isErrorIn();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $twig->addGlobal('msj_err',$msj_err);
//    $layout = $twig->load('inc/base.html.twig');
    echo $twig->render('inventario/procesadas.html.twig', ['entradas' => $entradas]);
    }

    public function emitidas($n){

    $total_cuota=$this->Model_Inv->aPag_sumaPro();
    $total_reg=$this->Model_Inv->aPag_countPro();
    $resultados_por_pagina = REG_X_PAG;

    $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
    if($_SERVER['REQUEST_METHOD'] == 'POST'){
        $resultados_por_pagina = 500;
    }

        $total_paginas = ceil($total_reg / $resultados_por_pagina);
        if ($n == 1) {
        $empezar_desde = 1;
        }else{
        }
        $empezar_desde = ($n-1) * $resultados_por_pagina;

    if($_SERVER['REQUEST_METHOD'] == 'POST'){
        $data = [
        'busca' =>strtoupper(trim($_POST['busca'])),
        'busqueda' =>strtoupper(trim($_POST['busqueda'])),
        ];
        $facturas = $this->Model_Inv->Inv_Fact_Gral_Busq($data);
        $total_reg= $this->Model_Inv->countPro_Busq($data);
    }else{
    $facturas = $this->Model_Inv->Inv_Fact_Gral($empezar_desde,$resultados_por_pagina);
    }

//var_dump($facturas);
//exit;
/*    $paridad = $this->Model_Prod->Prod_BuscarPar();
    $_SESSION['id_par']=$paridad->valor;
    $iva = $this->Model_Para->Para_Buscar();
    $_SESSION['id_iva']=$iva->iva;*/

        $paginacion = [
        'total_paginas' => $total_paginas,
        'pagina_actual' => $n,
        'total_cuota' => number_format($total_cuota[0], 8, ",", "."),
        'total_reg' => $total_reg,
         ];
    $msj_err=isErrorIn();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $twig->addGlobal('msj_err',$msj_err);
//    $layout = $twig->load('inc/base.html.twig');
    echo $twig->render('inventario/emitidas.html.twig', ['facturas' => $facturas,'paginacion' => $paginacion]);
    }

    public function imprimir($n){

    $facturas =     $this->Model_Inv->Inv_Fact_Busq($n);
    $facturas_det = $this->Model_Inv->Inv_Fact_BuscarItem($n);
//var_dump($facturas_det);
//exit;
    $msj_err=isErrorIn();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $twig->addGlobal('msj_err',$msj_err);
    $html= $twig->render('inventario/entrada_imp.html.twig', ['facturas' => $facturas,'facturas_det' => $facturas_det]);

                $pdfOptions = new Dompdf\Options();
                $pdfOptions->set('defaultFont', 'Arial');
                $pdfOptions->set('isRemoteEnabled',true);
 //       Instantiate Dompdf with our options
                $dompdf = new Dompdf\Dompdf($pdfOptions);

    //  $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->render();
                $dompdf->stream("Factura.pdf", ["Attachment" => false]);
    }

    public function existentes(){
	$prod = $this->Model_Pro->Prod_Gral();

    $msj_err=isErrorIn();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $html= $twig->render('inventario/existencia_imp.html.twig', ['prod' => $prod]);

                $pdfOptions = new Dompdf\Options();
                $pdfOptions->set('defaultFont', 'Arial');
                $pdfOptions->set('isRemoteEnabled',true);
 //       Instantiate Dompdf with our options
                $dompdf = new Dompdf\Dompdf($pdfOptions);

    //  $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->render();
                $dompdf->stream("existencia.pdf", ["Attachment" => false]);
    }

    public function poralmacen(){
	$alm = $this->Model_Inv->Inv_Gral_Alm();
	$mov = $this->Model_Inv->Inv_Gral_Mov();
	

    $msj_err=isErrorIn();
    $loader = new \Twig\Loader\FilesystemLoader('../app/views');
    $twig = new \Twig\Environment($loader, ['cache' => '../app/cache','auto_reload' => true,'debug' => true,]);
    $twig->addGlobal('names',$_SESSION['user_id']);
    $html= $twig->render('inventario/almacenes_imp.html.twig', ['alm' => $alm,'mov' => $mov]);

                $pdfOptions = new Dompdf\Options();
                $pdfOptions->set('defaultFont', 'Arial');
                $pdfOptions->set('isRemoteEnabled',true);
 //       Instantiate Dompdf with our options
                $dompdf = new Dompdf\Dompdf($pdfOptions);

    //  $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->render();
                $dompdf->stream("almacenes.pdf", ["Attachment" => false]);
    }


}
